IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Cbtes_Rec_Generar_Pago') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Cbtes_Rec_Generar_Pago 
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Rec_Generar_Pago]
@pId_Trans				INT,
@pId_Tipo_Val			CHAR(3),
@pValor_Nro				INT,	
@pFecha_Val				DATETIME,
@pFecha_Emision			DATETIME,
@pFecha_Acreditacion	DATETIME,
@pFecha_Vence			DATETIME,
@pImporte				DECIMAL(12,2),
@pId_Tarjeta			VARCHAR(10),
@pTarjeta_Nro			VARCHAR(25),
@pTarjeta_Vence			DATETIME,
@pTarjeta_Cod_Seguridad VARCHAR(10),
@pTarjeta_Cod_Autoriz	VARCHAR(10),
@pTarjeta_Lote			SMALLINT,
@pId_Cta_banco          INT
AS
SET NOCOUNT ON

DECLARE @Usar_Trans			TINYINT
--SET @Usar_Trans = ISNULL((SELECT 1 WHERE SERVERPROPERTY('ProductVersion') > '10.50.4000.0'),0)
IF @@TRANCOUNT > 0 SET @Usar_Trans = 0


/*Declaracion Variables Locales*/
DECLARE @Id_Valor INT
DECLARE @Id_Valor_Origen INT
DECLARE @Id_Estado_Valor SMALLINT
DECLARE @Descripcion VARCHAR(50)
DECLARE @Id_Cliente INT
DECLARE @Id_Proveedor INT
DECLARE @Id_Banco SMALLINT
DECLARE @Id_Cta_Banco SMALLINT
DECLARE @Id_Mov_Caja INT
DECLARE @Id_Moneda CHAR(3)
DECLARE @Cotizacion DECIMAL(9,4)
DECLARE @Id_Periodo_Caja INT
DECLARE @Propio TINYINT
DECLARE @Transferible TINYINT
DECLARE @Cuit VARCHAR(13)
DECLARE @Id_Chequera INT
DECLARE @Renglon_Nro_Caja SMALLINT
DECLARE @Flag_Conciliado TINYINT
DECLARE @Fecha_Conci DATETIME
DECLARE @Tarjeta_Cant_Cuotas TINYINT
DECLARE @Tarjeta_Imp_Cuota DECIMAL(12,2)
DECLARE @Tarjeta_Crit_Cuota CHAR(1)

DECLARE @Flag_Existe_Tipo_Valor TINYINT

DECLARE @Renglon_Nro SMALLINT
DECLARE @Id_Motivo_Estado SMALLINT
DECLARE @Fecha DATETIME

DECLARE @Id_Estado_Mov_Caja INT
DECLARE @Id_Tipo_Mov_Caja	SMALLINT
DECLARE @Lote				VARCHAR(20)

DECLARE @Id_Mov_Cta_Banco   INT




DECLARE @Mensaje			VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

--PRINT 'Procedimiento: CP_Cbtes_Rec_Generar_Pago Trans: '+ CAST(@pId_Trans AS VARCHAR(10))

BEGIN TRY
	IF @Usar_Trans = 1 BEGIN TRAN

	/*****************************************************************************/

	SET @Flag_Existe_Tipo_Valor = ISNULL((SELECT 1 FROM Valores_Tipos WHERE Id_Tipo_Val = @pId_Tipo_Val), 0)
	IF (@Flag_Existe_Tipo_Valor = 0)
	BEGIN
		SET @Mensaje = 'No existe el Tipo de Valor'

		SELECT	4001			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				--,@pId_Trans		AS Id_Trans
		IF @Usar_Trans = 1 AND @@TRANCOUNT > 0 ROLLBACK
		RETURN 4001
	END

	/*************************************************************************************************/

	SELECT  @Id_Cliente		= ISNULL(Id_Cliente, 0),
			@Id_Moneda		= ISNULL(Id_Moneda, 'PES'),
			@Cotizacion		= ISNULL(Cotizacion, 1),
			@Cuit			= ISNULL(Cuit, ''),
			@Fecha			= Fecha
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*****************************************************************************/
	
	SELECT  @Id_Periodo_Caja = ISNULL(Id_Periodo_Caja, 0)
	FROM Cajas_Mov
	WHERE 
	Id_Trans = @pId_Trans

	/*****************************************************************************/

	IF @pId_Tipo_Val IN ('TAR','CH3','CHP')         /*14/4/22  Gabriel*/
		SET @Id_Estado_Valor	= 3
	ELSE	
		SET @Id_Estado_Valor	= 4 /*No hay en carga*/
		/*entraba mal los estados*/

	SET @Id_Valor		= (SELECT MAX(ISNULL(Id_Valor,0)) + 1 FROM Valores)
	SET @Id_Valor_Origen = 0

	SET @Descripcion	= (SELECT ISNULL(Descripcion, '') FROM Valores_Tipos WHERE Id_Tipo_Val = @pId_Tipo_Val)
	SET @Id_Proveedor	= 0
	SET @Id_Banco		= (SELECT ISNULL(ID_Banco,0) FROM Bancos_Ctas WHERE Id_Cta_Banco = @pId_Cta_Banco)
	SET @Id_Cta_Banco	= @pId_Cta_Banco
	SET @Id_Mov_Caja	= 0
	SET @Propio			= 0
	SET @Transferible	= 0
	SET @Id_Chequera	= 0
	SET @Renglon_Nro_Caja = 1
	SET @Flag_Conciliado = 0
	--SET @Fecha_Conci NULL
	SET @Tarjeta_Cant_Cuotas = 0
	SET @Tarjeta_Imp_Cuota = 0
	SET @Tarjeta_Crit_Cuota = ''

	INSERT INTO dbo.Valores
	(Id_Valor,				Id_Valor_Origen,	Id_Trans,
	Id_Estado_Valor,		Id_Tipo_Val,		Valor_Nro,
	Descripcion,			Fecha_Val,			Fecha_Emision,
	Fecha_Acreditacion,		Fecha_Vence,		Id_Cliente,
	Id_Proveedor,			Id_Banco,			Id_Cta_Banco,
	Id_Mov_Caja,			Id_Moneda,			Importe,
	Id_Tarjeta,				Tarjeta_Nro,		Tarjeta_Vence,
	Tarjeta_Cod_Seguridad,	Tarjeta_Cod_Autoriz,Cotizacion,
	Id_Periodo_Caja,		Propio,				Transferible,
	Cuit,					Tarjeta_Lote,		Id_Chequera,
	Renglon_Nro_Caja,		Flag_Conciliado,	Fecha_Conci,
	Tarjeta_Cant_Cuotas,	Tarjeta_Imp_Cuota,	Tarjeta_Crit_Cuota)
	VALUES
	(@Id_Valor,				@Id_Valor_Origen,	@pId_Trans,
	@Id_Estado_Valor,		@pId_Tipo_Val,		@pValor_Nro,
	@Descripcion,			@pFecha_Val,		@pFecha_Emision,
	@pFecha_Acreditacion,	@pFecha_Vence,		@Id_Cliente,
	@Id_Proveedor,			@Id_Banco,			@Id_Cta_Banco,
	@Id_Mov_Caja,			@Id_Moneda,			@pImporte,
	@pId_Tarjeta,			@pTarjeta_Nro,		@pTarjeta_Vence,
	@pTarjeta_Cod_Seguridad,@pTarjeta_Cod_Autoriz,@Cotizacion,
	@Id_Periodo_Caja,		@Propio,			@Transferible,
	@Cuit,					@pTarjeta_Lote,		@Id_Chequera,
	@Renglon_Nro_Caja,		@Flag_Conciliado,	@Fecha_Conci,
	@Tarjeta_Cant_Cuotas,	@Tarjeta_Imp_Cuota,	@Tarjeta_Crit_Cuota)

	/*****************************************************************************/
	
	SET @Renglon_Nro = 1
	SET @Id_Motivo_Estado = 0
	SET @Descripcion = ''

	INSERT INTO dbo.Valores_Mov
	(Id_Valor,			Renglon_Nro,		Id_Trans,
	Id_Motivo_Estado,	Id_Estado_Valor,	Id_Periodo_Caja,
    Descripcion,		Fecha_Acreditacion,	Fecha,
    Renglon_Nro_Caja)
	VALUES
	(@Id_Valor,			@Renglon_Nro,		@pId_Trans,
	@Id_Motivo_Estado,	@Id_Estado_Valor,	@Id_Periodo_Caja,
    @Descripcion,		@pFecha_Acreditacion,@Fecha,
    @Renglon_Nro_Caja)
	
	/*****************************************************************************/
	
	IF @pId_Tipo_Val = 'DB'
	BEGIN
		SET @Id_Mov_Cta_Banco		= (SELECT MAX(ISNULL(Id_Mov_Cta_Banco,0)) + 1 FROM bancos_ctas_mov)
		SET @Lote =	 (SELECT ISNULL(lote,'') FROM Cbtes where id_Trans=@pId_Trans)
		
		INSERT INTO bancos_ctas_mov 
			(Id_Mov_Cta_Banco,	Id_Trans,				Id_Cta_Banco,		Id_Tipo_Mov_Cta_Banco,	
			Importe,			Id_Est_Mov_Cta_Banco, 	Comprobante_Nro,	Conciliado, 
			Fecha_Acreditacion, Descripcion,			Fecha_Mov)
		VALUES (@Id_Mov_Cta_Banco,	@pId_Trans,			@pId_Cta_banco,			9/*Deposito*/,	
			@pImporte,			1,						@Lote,					0,
			@pFecha_Acreditacion, @Lote,				@pFecha_Emision)
	END


	
	/*****************************************************************************/

	IF @Usar_Trans = 1 AND @@TRANCOUNT > 0 COMMIT

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Trans		AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			--,@pId_Trans		AS Id_Trans

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo; 
	IF @Usar_Trans = 1 AND @@TRANCOUNT > 0 ROLLBACK
	RETURN 9999
END CATCH

RETURN 0
--PRINT 'FIN Procedimiento: CP_Cbtes_Rec_Generar_Pago Trans: '+ CAST(@pId_Trans AS VARCHAR(10))
